package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFindingsReportRequest(
    filterCriteria: Optional[zio.aws.inspector2.model.FilterCriteria] =
      Optional.Absent,
    reportFormat: zio.aws.inspector2.model.ReportFormat,
    s3Destination: zio.aws.inspector2.model.Destination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest = {
    import CreateFindingsReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest
      .builder()
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .reportFormat(reportFormat.unwrap)
      .s3Destination(s3Destination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.CreateFindingsReportRequest.ReadOnly =
    zio.aws.inspector2.model.CreateFindingsReportRequest.wrap(buildAwsValue())
}
object CreateFindingsReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CreateFindingsReportRequest =
      zio.aws.inspector2.model.CreateFindingsReportRequest(
        filterCriteria.map(value => value.asEditable),
        reportFormat,
        s3Destination.asEditable
      )
    def filterCriteria
        : Optional[zio.aws.inspector2.model.FilterCriteria.ReadOnly]
    def reportFormat: zio.aws.inspector2.model.ReportFormat
    def s3Destination: zio.aws.inspector2.model.Destination.ReadOnly
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getReportFormat
        : ZIO[Any, Nothing, zio.aws.inspector2.model.ReportFormat] =
      ZIO.succeed(reportFormat)
    def getS3Destination
        : ZIO[Any, Nothing, zio.aws.inspector2.model.Destination.ReadOnly] =
      ZIO.succeed(s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest
  ) extends zio.aws.inspector2.model.CreateFindingsReportRequest.ReadOnly {
    override val filterCriteria
        : Optional[zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriteria())
        .map(value => zio.aws.inspector2.model.FilterCriteria.wrap(value))
    override val reportFormat: zio.aws.inspector2.model.ReportFormat =
      zio.aws.inspector2.model.ReportFormat.wrap(impl.reportFormat())
    override val s3Destination: zio.aws.inspector2.model.Destination.ReadOnly =
      zio.aws.inspector2.model.Destination.wrap(impl.s3Destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest
  ): zio.aws.inspector2.model.CreateFindingsReportRequest.ReadOnly =
    new Wrapper(impl)
}
