package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait AccountSortBy {
  def unwrap: software.amazon.awssdk.services.inspector2.model.AccountSortBy
}
object AccountSortBy {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.AccountSortBy
  ): zio.aws.inspector2.model.AccountSortBy = value match {
    case software.amazon.awssdk.services.inspector2.model.AccountSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.AccountSortBy.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.inspector2.model.AccountSortBy.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.inspector2.model.AccountSortBy.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.AccountSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AccountSortBy =
      software.amazon.awssdk.services.inspector2.model.AccountSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.inspector2.model.AccountSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AccountSortBy =
      software.amazon.awssdk.services.inspector2.model.AccountSortBy.CRITICAL
  }
  case object HIGH extends zio.aws.inspector2.model.AccountSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AccountSortBy =
      software.amazon.awssdk.services.inspector2.model.AccountSortBy.HIGH
  }
  case object ALL extends zio.aws.inspector2.model.AccountSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AccountSortBy =
      software.amazon.awssdk.services.inspector2.model.AccountSortBy.ALL
  }
}
