package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{
  FilterName,
  FilterArn,
  FilterDescription
}
import scala.jdk.CollectionConverters.*
final case class UpdateFilterRequest(
    action: Option[zio.aws.inspector2.model.FilterAction] = None,
    description: Option[FilterDescription] = None,
    filterArn: FilterArn,
    filterCriteria: Option[zio.aws.inspector2.model.FilterCriteria] = None,
    name: Option[FilterName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest = {
    import UpdateFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        description.map(value =>
          FilterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .filterArn(FilterArn.unwrap(filterArn): java.lang.String)
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        name.map(value => FilterName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.UpdateFilterRequest.ReadOnly =
    zio.aws.inspector2.model.UpdateFilterRequest.wrap(buildAwsValue())
}
object UpdateFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UpdateFilterRequest =
      zio.aws.inspector2.model.UpdateFilterRequest(
        action.map(value => value),
        description.map(value => value),
        filterArn,
        filterCriteria.map(value => value.asEditable),
        name.map(value => value)
      )
    def action: Option[zio.aws.inspector2.model.FilterAction]
    def description: Option[FilterDescription]
    def filterArn: FilterArn
    def filterCriteria: Option[zio.aws.inspector2.model.FilterCriteria.ReadOnly]
    def name: Option[FilterName]
    def getAction: ZIO[Any, AwsError, zio.aws.inspector2.model.FilterAction] =
      AwsError.unwrapOptionField("action", action)
    def getDescription: ZIO[Any, AwsError, FilterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFilterArn: ZIO[Any, Nothing, FilterArn] = ZIO.succeed(filterArn)
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getName: ZIO[Any, AwsError, FilterName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest
  ) extends zio.aws.inspector2.model.UpdateFilterRequest.ReadOnly {
    override val action: Option[zio.aws.inspector2.model.FilterAction] = scala
      .Option(impl.action())
      .map(value => zio.aws.inspector2.model.FilterAction.wrap(value))
    override val description: Option[FilterDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.inspector2.model.primitives.FilterDescription(value)
      )
    override val filterArn: FilterArn =
      zio.aws.inspector2.model.primitives.FilterArn(impl.filterArn())
    override val filterCriteria
        : Option[zio.aws.inspector2.model.FilterCriteria.ReadOnly] = scala
      .Option(impl.filterCriteria())
      .map(value => zio.aws.inspector2.model.FilterCriteria.wrap(value))
    override val name: Option[FilterName] = scala
      .Option(impl.name())
      .map(value => zio.aws.inspector2.model.primitives.FilterName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest
  ): zio.aws.inspector2.model.UpdateFilterRequest.ReadOnly = new Wrapper(impl)
}
