package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TitleAggregation(
    resourceType: Option[zio.aws.inspector2.model.AggregationResourceType] =
      None,
    sortBy: Option[zio.aws.inspector2.model.TitleSortBy] = None,
    sortOrder: Option[zio.aws.inspector2.model.SortOrder] = None,
    titles: Option[Iterable[zio.aws.inspector2.model.StringFilter]] = None,
    vulnerabilityIds: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.TitleAggregation = {
    import TitleAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.TitleAggregation
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        titles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.titles)
      .optionallyWith(
        vulnerabilityIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerabilityIds)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.TitleAggregation.ReadOnly =
    zio.aws.inspector2.model.TitleAggregation.wrap(buildAwsValue())
}
object TitleAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.TitleAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.TitleAggregation =
      zio.aws.inspector2.model.TitleAggregation(
        resourceType.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        titles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vulnerabilityIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceType: Option[zio.aws.inspector2.model.AggregationResourceType]
    def sortBy: Option[zio.aws.inspector2.model.TitleSortBy]
    def sortOrder: Option[zio.aws.inspector2.model.SortOrder]
    def titles: Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def vulnerabilityIds
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AggregationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSortBy: ZIO[Any, AwsError, zio.aws.inspector2.model.TitleSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getTitles: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("titles", titles)
    def getVulnerabilityIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerabilityIds", vulnerabilityIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.TitleAggregation
  ) extends zio.aws.inspector2.model.TitleAggregation.ReadOnly {
    override val resourceType
        : Option[zio.aws.inspector2.model.AggregationResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.inspector2.model.AggregationResourceType.wrap(value)
      )
    override val sortBy: Option[zio.aws.inspector2.model.TitleSortBy] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.inspector2.model.TitleSortBy.wrap(value))
    override val sortOrder: Option[zio.aws.inspector2.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
    override val titles
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.titles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val vulnerabilityIds
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.vulnerabilityIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.TitleAggregation
  ): zio.aws.inspector2.model.TitleAggregation.ReadOnly = new Wrapper(impl)
}
