package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SeverityCounts(
    all: Option[Long] = None,
    critical: Option[Long] = None,
    high: Option[Long] = None,
    medium: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.SeverityCounts = {
    import SeverityCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.SeverityCounts
      .builder()
      .optionallyWith(all.map(value => value: java.lang.Long))(_.all)
      .optionallyWith(critical.map(value => value: java.lang.Long))(_.critical)
      .optionallyWith(high.map(value => value: java.lang.Long))(_.high)
      .optionallyWith(medium.map(value => value: java.lang.Long))(_.medium)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.SeverityCounts.ReadOnly =
    zio.aws.inspector2.model.SeverityCounts.wrap(buildAwsValue())
}
object SeverityCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.SeverityCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.SeverityCounts =
      zio.aws.inspector2.model.SeverityCounts(
        all.map(value => value),
        critical.map(value => value),
        high.map(value => value),
        medium.map(value => value)
      )
    def all: Option[Long]
    def critical: Option[Long]
    def high: Option[Long]
    def medium: Option[Long]
    def getAll: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("all", all)
    def getCritical: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("critical", critical)
    def getHigh: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("high", high)
    def getMedium: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("medium", medium)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.SeverityCounts
  ) extends zio.aws.inspector2.model.SeverityCounts.ReadOnly {
    override val all: Option[Long] =
      scala.Option(impl.all()).map(value => value: Long)
    override val critical: Option[Long] =
      scala.Option(impl.critical()).map(value => value: Long)
    override val high: Option[Long] =
      scala.Option(impl.high()).map(value => value: Long)
    override val medium: Option[Long] =
      scala.Option(impl.medium()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.SeverityCounts
  ): zio.aws.inspector2.model.SeverityCounts.ReadOnly = new Wrapper(impl)
}
