package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ScanStatusCode {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ScanStatusCode
}
object ScanStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ScanStatusCode
  ): zio.aws.inspector2.model.ScanStatusCode = value match {
    case software.amazon.awssdk.services.inspector2.model.ScanStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusCode.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusCode.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ScanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusCode =
      software.amazon.awssdk.services.inspector2.model.ScanStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.inspector2.model.ScanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusCode =
      software.amazon.awssdk.services.inspector2.model.ScanStatusCode.ACTIVE
  }
  case object INACTIVE extends zio.aws.inspector2.model.ScanStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusCode =
      software.amazon.awssdk.services.inspector2.model.ScanStatusCode.INACTIVE
  }
}
