package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceDetails(
    awsEc2Instance: Option[zio.aws.inspector2.model.AwsEc2InstanceDetails] =
      None,
    awsEcrContainerImage: Option[
      zio.aws.inspector2.model.AwsEcrContainerImageDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceDetails = {
    import ResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceDetails
      .builder()
      .optionallyWith(awsEc2Instance.map(value => value.buildAwsValue()))(
        _.awsEc2Instance
      )
      .optionallyWith(awsEcrContainerImage.map(value => value.buildAwsValue()))(
        _.awsEcrContainerImage
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceDetails.ReadOnly =
    zio.aws.inspector2.model.ResourceDetails.wrap(buildAwsValue())
}
object ResourceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceDetails =
      zio.aws.inspector2.model.ResourceDetails(
        awsEc2Instance.map(value => value.asEditable),
        awsEcrContainerImage.map(value => value.asEditable)
      )
    def awsEc2Instance
        : Option[zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly]
    def awsEcrContainerImage
        : Option[zio.aws.inspector2.model.AwsEcrContainerImageDetails.ReadOnly]
    def getAwsEc2Instance: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEc2Instance", awsEc2Instance)
    def getAwsEcrContainerImage: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AwsEcrContainerImageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEcrContainerImage", awsEcrContainerImage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceDetails
  ) extends zio.aws.inspector2.model.ResourceDetails.ReadOnly {
    override val awsEc2Instance
        : Option[zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly] =
      scala
        .Option(impl.awsEc2Instance())
        .map(value =>
          zio.aws.inspector2.model.AwsEc2InstanceDetails.wrap(value)
        )
    override val awsEcrContainerImage: Option[
      zio.aws.inspector2.model.AwsEcrContainerImageDetails.ReadOnly
    ] = scala
      .Option(impl.awsEcrContainerImage())
      .map(value =>
        zio.aws.inspector2.model.AwsEcrContainerImageDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceDetails
  ): zio.aws.inspector2.model.ResourceDetails.ReadOnly = new Wrapper(impl)
}
