package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RepositoryAggregation(
    repositories: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    sortBy: Option[zio.aws.inspector2.model.RepositorySortBy] = None,
    sortOrder: Option[zio.aws.inspector2.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.RepositoryAggregation = {
    import RepositoryAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.RepositoryAggregation
      .builder()
      .optionallyWith(
        repositories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.repositories)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.RepositoryAggregation.ReadOnly =
    zio.aws.inspector2.model.RepositoryAggregation.wrap(buildAwsValue())
}
object RepositoryAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.RepositoryAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.RepositoryAggregation =
      zio.aws.inspector2.model.RepositoryAggregation(
        repositories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def repositories
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def sortBy: Option[zio.aws.inspector2.model.RepositorySortBy]
    def sortOrder: Option[zio.aws.inspector2.model.SortOrder]
    def getRepositories: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("repositories", repositories)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.inspector2.model.RepositorySortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.RepositoryAggregation
  ) extends zio.aws.inspector2.model.RepositoryAggregation.ReadOnly {
    override val repositories
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.repositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val sortBy: Option[zio.aws.inspector2.model.RepositorySortBy] =
      scala
        .Option(impl.sortBy())
        .map(value => zio.aws.inspector2.model.RepositorySortBy.wrap(value))
    override val sortOrder: Option[zio.aws.inspector2.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.RepositoryAggregation
  ): zio.aws.inspector2.model.RepositoryAggregation.ReadOnly = new Wrapper(impl)
}
