package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Remediation(
    recommendation: Option[zio.aws.inspector2.model.Recommendation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Remediation = {
    import Remediation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Remediation
      .builder()
      .optionallyWith(recommendation.map(value => value.buildAwsValue()))(
        _.recommendation
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Remediation.ReadOnly =
    zio.aws.inspector2.model.Remediation.wrap(buildAwsValue())
}
object Remediation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Remediation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Remediation =
      zio.aws.inspector2.model
        .Remediation(recommendation.map(value => value.asEditable))
    def recommendation: Option[zio.aws.inspector2.model.Recommendation.ReadOnly]
    def getRecommendation
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Recommendation.ReadOnly] =
      AwsError.unwrapOptionField("recommendation", recommendation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Remediation
  ) extends zio.aws.inspector2.model.Remediation.ReadOnly {
    override val recommendation
        : Option[zio.aws.inspector2.model.Recommendation.ReadOnly] = scala
      .Option(impl.recommendation())
      .map(value => zio.aws.inspector2.model.Recommendation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Remediation
  ): zio.aws.inspector2.model.Remediation.ReadOnly = new Wrapper(impl)
}
