package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class Recommendation(
    url: Option[NonEmptyString] = None,
    text: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Recommendation = {
    import Recommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Recommendation
      .builder()
      .optionallyWith(
        url.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        text.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.text)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Recommendation.ReadOnly =
    zio.aws.inspector2.model.Recommendation.wrap(buildAwsValue())
}
object Recommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Recommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Recommendation =
      zio.aws.inspector2.model
        .Recommendation(url.map(value => value), text.map(value => value))
    def url: Option[NonEmptyString]
    def text: Option[NonEmptyString]
    def getUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", url)
    def getText: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("text", text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Recommendation
  ) extends zio.aws.inspector2.model.Recommendation.ReadOnly {
    override val url: Option[NonEmptyString] = scala
      .Option(impl.url())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val text: Option[NonEmptyString] = scala
      .Option(impl.text())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Recommendation
  ): zio.aws.inspector2.model.Recommendation.ReadOnly = new Wrapper(impl)
}
