package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.inspector2.model.primitives.{
  DateTimeTimestamp,
  VulnerabilityId,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class PackageVulnerabilityDetails(
    cvss: Option[Iterable[zio.aws.inspector2.model.CvssScore]] = None,
    referenceUrls: Option[Iterable[NonEmptyString]] = None,
    relatedVulnerabilities: Option[Iterable[VulnerabilityId]] = None,
    source: NonEmptyString,
    sourceUrl: Option[NonEmptyString] = None,
    vendorCreatedAt: Option[DateTimeTimestamp] = None,
    vendorSeverity: Option[NonEmptyString] = None,
    vendorUpdatedAt: Option[DateTimeTimestamp] = None,
    vulnerabilityId: VulnerabilityId,
    vulnerablePackages: Iterable[zio.aws.inspector2.model.VulnerablePackage]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.PackageVulnerabilityDetails = {
    import PackageVulnerabilityDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.PackageVulnerabilityDetails
      .builder()
      .optionallyWith(
        cvss.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cvss)
      .optionallyWith(
        referenceUrls.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.referenceUrls)
      .optionallyWith(
        relatedVulnerabilities.map(value =>
          value.map { item =>
            VulnerabilityId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedVulnerabilities)
      .source(NonEmptyString.unwrap(source): java.lang.String)
      .optionallyWith(
        sourceUrl.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceUrl)
      .optionallyWith(
        vendorCreatedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.vendorCreatedAt)
      .optionallyWith(
        vendorSeverity.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vendorSeverity)
      .optionallyWith(
        vendorUpdatedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.vendorUpdatedAt)
      .vulnerabilityId(
        VulnerabilityId.unwrap(vulnerabilityId): java.lang.String
      )
      .vulnerablePackages(vulnerablePackages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.PackageVulnerabilityDetails.ReadOnly =
    zio.aws.inspector2.model.PackageVulnerabilityDetails.wrap(buildAwsValue())
}
object PackageVulnerabilityDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.PackageVulnerabilityDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.PackageVulnerabilityDetails =
      zio.aws.inspector2.model.PackageVulnerabilityDetails(
        cvss.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        referenceUrls.map(value => value),
        relatedVulnerabilities.map(value => value),
        source,
        sourceUrl.map(value => value),
        vendorCreatedAt.map(value => value),
        vendorSeverity.map(value => value),
        vendorUpdatedAt.map(value => value),
        vulnerabilityId,
        vulnerablePackages.map { item =>
          item.asEditable
        }
      )
    def cvss: Option[List[zio.aws.inspector2.model.CvssScore.ReadOnly]]
    def referenceUrls: Option[List[NonEmptyString]]
    def relatedVulnerabilities: Option[List[VulnerabilityId]]
    def source: NonEmptyString
    def sourceUrl: Option[NonEmptyString]
    def vendorCreatedAt: Option[DateTimeTimestamp]
    def vendorSeverity: Option[NonEmptyString]
    def vendorUpdatedAt: Option[DateTimeTimestamp]
    def vulnerabilityId: VulnerabilityId
    def vulnerablePackages
        : List[zio.aws.inspector2.model.VulnerablePackage.ReadOnly]
    def getCvss: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CvssScore.ReadOnly
    ]] = AwsError.unwrapOptionField("cvss", cvss)
    def getReferenceUrls: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("referenceUrls", referenceUrls)
    def getRelatedVulnerabilities: ZIO[Any, AwsError, List[VulnerabilityId]] =
      AwsError.unwrapOptionField(
        "relatedVulnerabilities",
        relatedVulnerabilities
      )
    def getSource: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(source)
    def getSourceUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceUrl", sourceUrl)
    def getVendorCreatedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("vendorCreatedAt", vendorCreatedAt)
    def getVendorSeverity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vendorSeverity", vendorSeverity)
    def getVendorUpdatedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("vendorUpdatedAt", vendorUpdatedAt)
    def getVulnerabilityId: ZIO[Any, Nothing, VulnerabilityId] =
      ZIO.succeed(vulnerabilityId)
    def getVulnerablePackages: ZIO[Any, Nothing, List[
      zio.aws.inspector2.model.VulnerablePackage.ReadOnly
    ]] = ZIO.succeed(vulnerablePackages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.PackageVulnerabilityDetails
  ) extends zio.aws.inspector2.model.PackageVulnerabilityDetails.ReadOnly {
    override val cvss
        : Option[List[zio.aws.inspector2.model.CvssScore.ReadOnly]] = scala
      .Option(impl.cvss())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CvssScore.wrap(item)
        }.toList
      )
    override val referenceUrls: Option[List[NonEmptyString]] = scala
      .Option(impl.referenceUrls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val relatedVulnerabilities: Option[List[VulnerabilityId]] = scala
      .Option(impl.relatedVulnerabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.VulnerabilityId(item)
        }.toList
      )
    override val source: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.source())
    override val sourceUrl: Option[NonEmptyString] = scala
      .Option(impl.sourceUrl())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val vendorCreatedAt: Option[DateTimeTimestamp] = scala
      .Option(impl.vendorCreatedAt())
      .map(value =>
        zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
      )
    override val vendorSeverity: Option[NonEmptyString] = scala
      .Option(impl.vendorSeverity())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val vendorUpdatedAt: Option[DateTimeTimestamp] = scala
      .Option(impl.vendorUpdatedAt())
      .map(value =>
        zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
      )
    override val vulnerabilityId: VulnerabilityId =
      zio.aws.inspector2.model.primitives
        .VulnerabilityId(impl.vulnerabilityId())
    override val vulnerablePackages
        : List[zio.aws.inspector2.model.VulnerablePackage.ReadOnly] = impl
      .vulnerablePackages()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.VulnerablePackage.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.PackageVulnerabilityDetails
  ): zio.aws.inspector2.model.PackageVulnerabilityDetails.ReadOnly =
    new Wrapper(impl)
}
