package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PackageAggregation(
    packageNames: Option[Iterable[zio.aws.inspector2.model.StringFilter]] =
      None,
    sortBy: Option[zio.aws.inspector2.model.PackageSortBy] = None,
    sortOrder: Option[zio.aws.inspector2.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.PackageAggregation = {
    import PackageAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.PackageAggregation
      .builder()
      .optionallyWith(
        packageNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packageNames)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.PackageAggregation.ReadOnly =
    zio.aws.inspector2.model.PackageAggregation.wrap(buildAwsValue())
}
object PackageAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.PackageAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.PackageAggregation =
      zio.aws.inspector2.model.PackageAggregation(
        packageNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def packageNames
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def sortBy: Option[zio.aws.inspector2.model.PackageSortBy]
    def sortOrder: Option[zio.aws.inspector2.model.SortOrder]
    def getPackageNames: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("packageNames", packageNames)
    def getSortBy: ZIO[Any, AwsError, zio.aws.inspector2.model.PackageSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.PackageAggregation
  ) extends zio.aws.inspector2.model.PackageAggregation.ReadOnly {
    override val packageNames
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.packageNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val sortBy: Option[zio.aws.inspector2.model.PackageSortBy] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.inspector2.model.PackageSortBy.wrap(value))
    override val sortOrder: Option[zio.aws.inspector2.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.PackageAggregation
  ): zio.aws.inspector2.model.PackageAggregation.ReadOnly = new Wrapper(impl)
}
