package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NumberFilter(
    lowerInclusive: Option[Double] = None,
    upperInclusive: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.NumberFilter = {
    import NumberFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.NumberFilter
      .builder()
      .optionallyWith(lowerInclusive.map(value => value: java.lang.Double))(
        _.lowerInclusive
      )
      .optionallyWith(upperInclusive.map(value => value: java.lang.Double))(
        _.upperInclusive
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.NumberFilter.ReadOnly =
    zio.aws.inspector2.model.NumberFilter.wrap(buildAwsValue())
}
object NumberFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.NumberFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.NumberFilter =
      zio.aws.inspector2.model.NumberFilter(
        lowerInclusive.map(value => value),
        upperInclusive.map(value => value)
      )
    def lowerInclusive: Option[Double]
    def upperInclusive: Option[Double]
    def getLowerInclusive: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("lowerInclusive", lowerInclusive)
    def getUpperInclusive: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("upperInclusive", upperInclusive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.NumberFilter
  ) extends zio.aws.inspector2.model.NumberFilter.ReadOnly {
    override val lowerInclusive: Option[Double] =
      scala.Option(impl.lowerInclusive()).map(value => value: Double)
    override val upperInclusive: Option[Double] =
      scala.Option(impl.upperInclusive()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.NumberFilter
  ): zio.aws.inspector2.model.NumberFilter.ReadOnly = new Wrapper(impl)
}
