package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.inspector2.model.primitives.{DateTimeTimestamp, AccountId}
import scala.jdk.CollectionConverters.*
final case class Member(
    accountId: Option[AccountId] = None,
    delegatedAdminAccountId: Option[AccountId] = None,
    relationshipStatus: Option[zio.aws.inspector2.model.RelationshipStatus] =
      None,
    updatedAt: Option[DateTimeTimestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Member = {
    import Member.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Member
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        delegatedAdminAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.delegatedAdminAccountId)
      .optionallyWith(relationshipStatus.map(value => value.unwrap))(
        _.relationshipStatus
      )
      .optionallyWith(
        updatedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Member.ReadOnly =
    zio.aws.inspector2.model.Member.wrap(buildAwsValue())
}
object Member {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.Member] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Member =
      zio.aws.inspector2.model.Member(
        accountId.map(value => value),
        delegatedAdminAccountId.map(value => value),
        relationshipStatus.map(value => value),
        updatedAt.map(value => value)
      )
    def accountId: Option[AccountId]
    def delegatedAdminAccountId: Option[AccountId]
    def relationshipStatus: Option[zio.aws.inspector2.model.RelationshipStatus]
    def updatedAt: Option[DateTimeTimestamp]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getDelegatedAdminAccountId: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("delegatedAdminAccountId", delegatedAdminAccountId)
    def getRelationshipStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.RelationshipStatus] =
      AwsError.unwrapOptionField("relationshipStatus", relationshipStatus)
    def getUpdatedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Member
  ) extends zio.aws.inspector2.model.Member.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val delegatedAdminAccountId: Option[AccountId] = scala
      .Option(impl.delegatedAdminAccountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val relationshipStatus
        : Option[zio.aws.inspector2.model.RelationshipStatus] = scala
      .Option(impl.relationshipStatus())
      .map(value => zio.aws.inspector2.model.RelationshipStatus.wrap(value))
    override val updatedAt: Option[DateTimeTimestamp] = scala
      .Option(impl.updatedAt())
      .map(value =>
        zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Member
  ): zio.aws.inspector2.model.Member.ReadOnly = new Wrapper(impl)
}
