package zio.aws.inspector2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{NextToken, ListMembersMaxResults}
import scala.jdk.CollectionConverters.*
final case class ListMembersRequest(
    maxResults: Option[ListMembersMaxResults] = None,
    nextToken: Option[NextToken] = None,
    onlyAssociated: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListMembersRequest = {
    import ListMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListMembersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ListMembersMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(onlyAssociated.map(value => value: java.lang.Boolean))(
        _.onlyAssociated
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListMembersRequest.ReadOnly =
    zio.aws.inspector2.model.ListMembersRequest.wrap(buildAwsValue())
}
object ListMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListMembersRequest =
      zio.aws.inspector2.model.ListMembersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        onlyAssociated.map(value => value)
      )
    def maxResults: Option[ListMembersMaxResults]
    def nextToken: Option[NextToken]
    def onlyAssociated: Option[Boolean]
    def getMaxResults: ZIO[Any, AwsError, ListMembersMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOnlyAssociated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("onlyAssociated", onlyAssociated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListMembersRequest
  ) extends zio.aws.inspector2.model.ListMembersRequest.ReadOnly {
    override val maxResults: Option[ListMembersMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.inspector2.model.primitives.ListMembersMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val onlyAssociated: Option[Boolean] =
      scala.Option(impl.onlyAssociated()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListMembersRequest
  ): zio.aws.inspector2.model.ListMembersRequest.ReadOnly = new Wrapper(impl)
}
