package zio.aws.inspector2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{
  NextToken,
  ListFindingAggregationsMaxResults
}
import scala.jdk.CollectionConverters.*
final case class ListFindingAggregationsRequest(
    accountIds: Option[Iterable[zio.aws.inspector2.model.StringFilter]] = None,
    aggregationRequest: Option[zio.aws.inspector2.model.AggregationRequest] =
      None,
    aggregationType: zio.aws.inspector2.model.AggregationType,
    maxResults: Option[ListFindingAggregationsMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest = {
    import ListFindingAggregationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(aggregationRequest.map(value => value.buildAwsValue()))(
        _.aggregationRequest
      )
      .aggregationType(aggregationType.unwrap)
      .optionallyWith(
        maxResults.map(value =>
          ListFindingAggregationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListFindingAggregationsRequest.ReadOnly =
    zio.aws.inspector2.model.ListFindingAggregationsRequest
      .wrap(buildAwsValue())
}
object ListFindingAggregationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListFindingAggregationsRequest =
      zio.aws.inspector2.model.ListFindingAggregationsRequest(
        accountIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aggregationRequest.map(value => value.asEditable),
        aggregationType,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def accountIds: Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def aggregationRequest
        : Option[zio.aws.inspector2.model.AggregationRequest.ReadOnly]
    def aggregationType: zio.aws.inspector2.model.AggregationType
    def maxResults: Option[ListFindingAggregationsMaxResults]
    def nextToken: Option[NextToken]
    def getAccountIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("accountIds", accountIds)
    def getAggregationRequest: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AggregationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("aggregationRequest", aggregationRequest)
    def getAggregationType
        : ZIO[Any, Nothing, zio.aws.inspector2.model.AggregationType] =
      ZIO.succeed(aggregationType)
    def getMaxResults: ZIO[Any, AwsError, ListFindingAggregationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest
  ) extends zio.aws.inspector2.model.ListFindingAggregationsRequest.ReadOnly {
    override val accountIds
        : Option[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.StringFilter.wrap(item)
        }.toList
      )
    override val aggregationRequest
        : Option[zio.aws.inspector2.model.AggregationRequest.ReadOnly] = scala
      .Option(impl.aggregationRequest())
      .map(value => zio.aws.inspector2.model.AggregationRequest.wrap(value))
    override val aggregationType: zio.aws.inspector2.model.AggregationType =
      zio.aws.inspector2.model.AggregationType.wrap(impl.aggregationType())
    override val maxResults: Option[ListFindingAggregationsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.inspector2.model.primitives
          .ListFindingAggregationsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest
  ): zio.aws.inspector2.model.ListFindingAggregationsRequest.ReadOnly =
    new Wrapper(impl)
}
