package zio.aws.inspector2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{
  NextToken,
  ListFilterMaxResults,
  FilterArn
}
import scala.jdk.CollectionConverters.*
final case class ListFiltersRequest(
    action: Option[zio.aws.inspector2.model.FilterAction] = None,
    arns: Option[Iterable[FilterArn]] = None,
    maxResults: Option[ListFilterMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListFiltersRequest = {
    import ListFiltersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListFiltersRequest
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        arns.map(value =>
          value.map { item =>
            FilterArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.arns)
      .optionallyWith(
        maxResults.map(value => ListFilterMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListFiltersRequest.ReadOnly =
    zio.aws.inspector2.model.ListFiltersRequest.wrap(buildAwsValue())
}
object ListFiltersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListFiltersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListFiltersRequest =
      zio.aws.inspector2.model.ListFiltersRequest(
        action.map(value => value),
        arns.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def action: Option[zio.aws.inspector2.model.FilterAction]
    def arns: Option[List[FilterArn]]
    def maxResults: Option[ListFilterMaxResults]
    def nextToken: Option[NextToken]
    def getAction: ZIO[Any, AwsError, zio.aws.inspector2.model.FilterAction] =
      AwsError.unwrapOptionField("action", action)
    def getArns: ZIO[Any, AwsError, List[FilterArn]] =
      AwsError.unwrapOptionField("arns", arns)
    def getMaxResults: ZIO[Any, AwsError, ListFilterMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListFiltersRequest
  ) extends zio.aws.inspector2.model.ListFiltersRequest.ReadOnly {
    override val action: Option[zio.aws.inspector2.model.FilterAction] = scala
      .Option(impl.action())
      .map(value => zio.aws.inspector2.model.FilterAction.wrap(value))
    override val arns: Option[List[FilterArn]] = scala
      .Option(impl.arns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.FilterArn(item)
        }.toList
      )
    override val maxResults: Option[ListFilterMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.inspector2.model.primitives.ListFilterMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListFiltersRequest
  ): zio.aws.inspector2.model.ListFiltersRequest.ReadOnly = new Wrapper(impl)
}
