package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListCoverageStatisticsRequest(
    filterCriteria: Option[zio.aws.inspector2.model.CoverageFilterCriteria] =
      None,
    groupBy: Option[zio.aws.inspector2.model.GroupKey] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest = {
    import ListCoverageStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest
      .builder()
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(groupBy.map(value => value.unwrap))(_.groupBy)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListCoverageStatisticsRequest.ReadOnly =
    zio.aws.inspector2.model.ListCoverageStatisticsRequest.wrap(buildAwsValue())
}
object ListCoverageStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListCoverageStatisticsRequest =
      zio.aws.inspector2.model.ListCoverageStatisticsRequest(
        filterCriteria.map(value => value.asEditable),
        groupBy.map(value => value),
        nextToken.map(value => value)
      )
    def filterCriteria
        : Option[zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly]
    def groupBy: Option[zio.aws.inspector2.model.GroupKey]
    def nextToken: Option[NextToken]
    def getFilterCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getGroupBy: ZIO[Any, AwsError, zio.aws.inspector2.model.GroupKey] =
      AwsError.unwrapOptionField("groupBy", groupBy)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest
  ) extends zio.aws.inspector2.model.ListCoverageStatisticsRequest.ReadOnly {
    override val filterCriteria
        : Option[zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly] =
      scala
        .Option(impl.filterCriteria())
        .map(value =>
          zio.aws.inspector2.model.CoverageFilterCriteria.wrap(value)
        )
    override val groupBy: Option[zio.aws.inspector2.model.GroupKey] = scala
      .Option(impl.groupBy())
      .map(value => zio.aws.inspector2.model.GroupKey.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest
  ): zio.aws.inspector2.model.ListCoverageStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
