package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListCoverageResponse(
    coveredResources: Option[
      Iterable[zio.aws.inspector2.model.CoveredResource]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCoverageResponse = {
    import ListCoverageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCoverageResponse
      .builder()
      .optionallyWith(
        coveredResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.coveredResources)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListCoverageResponse.ReadOnly =
    zio.aws.inspector2.model.ListCoverageResponse.wrap(buildAwsValue())
}
object ListCoverageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCoverageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListCoverageResponse =
      zio.aws.inspector2.model.ListCoverageResponse(
        coveredResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def coveredResources
        : Option[List[zio.aws.inspector2.model.CoveredResource.ReadOnly]]
    def nextToken: Option[NextToken]
    def getCoveredResources: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoveredResource.ReadOnly
    ]] = AwsError.unwrapOptionField("coveredResources", coveredResources)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCoverageResponse
  ) extends zio.aws.inspector2.model.ListCoverageResponse.ReadOnly {
    override val coveredResources
        : Option[List[zio.aws.inspector2.model.CoveredResource.ReadOnly]] =
      scala
        .Option(impl.coveredResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoveredResource.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCoverageResponse
  ): zio.aws.inspector2.model.ListCoverageResponse.ReadOnly = new Wrapper(impl)
}
