package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListAccountPermissionsResponse(
    nextToken: Option[NextToken] = None,
    permissions: Iterable[zio.aws.inspector2.model.Permission]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse = {
    import ListAccountPermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .permissions(permissions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListAccountPermissionsResponse.ReadOnly =
    zio.aws.inspector2.model.ListAccountPermissionsResponse
      .wrap(buildAwsValue())
}
object ListAccountPermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListAccountPermissionsResponse =
      zio.aws.inspector2.model.ListAccountPermissionsResponse(
        nextToken.map(value => value),
        permissions.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[NextToken]
    def permissions: List[zio.aws.inspector2.model.Permission.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPermissions: ZIO[Any, Nothing, List[
      zio.aws.inspector2.model.Permission.ReadOnly
    ]] = ZIO.succeed(permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse
  ) extends zio.aws.inspector2.model.ListAccountPermissionsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val permissions
        : List[zio.aws.inspector2.model.Permission.ReadOnly] = impl
      .permissions()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.Permission.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse
  ): zio.aws.inspector2.model.ListAccountPermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
