package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetMemberResponse(
    member: Option[zio.aws.inspector2.model.Member] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetMemberResponse = {
    import GetMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetMemberResponse
      .builder()
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.GetMemberResponse.ReadOnly =
    zio.aws.inspector2.model.GetMemberResponse.wrap(buildAwsValue())
}
object GetMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetMemberResponse =
      zio.aws.inspector2.model
        .GetMemberResponse(member.map(value => value.asEditable))
    def member: Option[zio.aws.inspector2.model.Member.ReadOnly]
    def getMember
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Member.ReadOnly] =
      AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetMemberResponse
  ) extends zio.aws.inspector2.model.GetMemberResponse.ReadOnly {
    override val member: Option[zio.aws.inspector2.model.Member.ReadOnly] =
      scala
        .Option(impl.member())
        .map(value => zio.aws.inspector2.model.Member.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetMemberResponse
  ): zio.aws.inspector2.model.GetMemberResponse.ReadOnly = new Wrapper(impl)
}
