package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.ReportId
import scala.jdk.CollectionConverters.*
final case class GetFindingsReportStatusRequest(
    reportId: Option[ReportId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest = {
    import GetFindingsReportStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest
      .builder()
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.GetFindingsReportStatusRequest.ReadOnly =
    zio.aws.inspector2.model.GetFindingsReportStatusRequest
      .wrap(buildAwsValue())
}
object GetFindingsReportStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetFindingsReportStatusRequest =
      zio.aws.inspector2.model
        .GetFindingsReportStatusRequest(reportId.map(value => value))
    def reportId: Option[ReportId]
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest
  ) extends zio.aws.inspector2.model.GetFindingsReportStatusRequest.ReadOnly {
    override val reportId: Option[ReportId] = scala
      .Option(impl.reportId())
      .map(value => zio.aws.inspector2.model.primitives.ReportId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest
  ): zio.aws.inspector2.model.GetFindingsReportStatusRequest.ReadOnly =
    new Wrapper(impl)
}
