package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDelegatedAdminAccountResponse(
    delegatedAdmin: Option[zio.aws.inspector2.model.DelegatedAdmin] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountResponse = {
    import GetDelegatedAdminAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountResponse
      .builder()
      .optionallyWith(delegatedAdmin.map(value => value.buildAwsValue()))(
        _.delegatedAdmin
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.GetDelegatedAdminAccountResponse.ReadOnly =
    zio.aws.inspector2.model.GetDelegatedAdminAccountResponse
      .wrap(buildAwsValue())
}
object GetDelegatedAdminAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetDelegatedAdminAccountResponse =
      zio.aws.inspector2.model.GetDelegatedAdminAccountResponse(
        delegatedAdmin.map(value => value.asEditable)
      )
    def delegatedAdmin: Option[zio.aws.inspector2.model.DelegatedAdmin.ReadOnly]
    def getDelegatedAdmin
        : ZIO[Any, AwsError, zio.aws.inspector2.model.DelegatedAdmin.ReadOnly] =
      AwsError.unwrapOptionField("delegatedAdmin", delegatedAdmin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountResponse
  ) extends zio.aws.inspector2.model.GetDelegatedAdminAccountResponse.ReadOnly {
    override val delegatedAdmin
        : Option[zio.aws.inspector2.model.DelegatedAdmin.ReadOnly] = scala
      .Option(impl.delegatedAdmin())
      .map(value => zio.aws.inspector2.model.DelegatedAdmin.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountResponse
  ): zio.aws.inspector2.model.GetDelegatedAdminAccountResponse.ReadOnly =
    new Wrapper(impl)
}
