package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.inspector2.model.primitives.{
  FindingDescription,
  AccountId,
  FindingArn,
  DateTimeTimestamp,
  FindingTitle
}
import scala.jdk.CollectionConverters.*
final case class Finding(
    awsAccountId: AccountId,
    description: FindingDescription,
    findingArn: FindingArn,
    firstObservedAt: DateTimeTimestamp,
    inspectorScore: Option[Double] = None,
    inspectorScoreDetails: Option[
      zio.aws.inspector2.model.InspectorScoreDetails
    ] = None,
    lastObservedAt: DateTimeTimestamp,
    networkReachabilityDetails: Option[
      zio.aws.inspector2.model.NetworkReachabilityDetails
    ] = None,
    packageVulnerabilityDetails: Option[
      zio.aws.inspector2.model.PackageVulnerabilityDetails
    ] = None,
    remediation: zio.aws.inspector2.model.Remediation,
    resources: Iterable[zio.aws.inspector2.model.Resource],
    severity: zio.aws.inspector2.model.Severity,
    status: zio.aws.inspector2.model.FindingStatus,
    title: Option[FindingTitle] = None,
    `type`: zio.aws.inspector2.model.FindingType,
    updatedAt: Option[DateTimeTimestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Finding = {
    import Finding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Finding
      .builder()
      .awsAccountId(AccountId.unwrap(awsAccountId): java.lang.String)
      .description(FindingDescription.unwrap(description): java.lang.String)
      .findingArn(FindingArn.unwrap(findingArn): java.lang.String)
      .firstObservedAt(DateTimeTimestamp.unwrap(firstObservedAt): Instant)
      .optionallyWith(inspectorScore.map(value => value: java.lang.Double))(
        _.inspectorScore
      )
      .optionallyWith(
        inspectorScoreDetails.map(value => value.buildAwsValue())
      )(_.inspectorScoreDetails)
      .lastObservedAt(DateTimeTimestamp.unwrap(lastObservedAt): Instant)
      .optionallyWith(
        networkReachabilityDetails.map(value => value.buildAwsValue())
      )(_.networkReachabilityDetails)
      .optionallyWith(
        packageVulnerabilityDetails.map(value => value.buildAwsValue())
      )(_.packageVulnerabilityDetails)
      .remediation(remediation.buildAwsValue())
      .resources(resources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .severity(severity.unwrap)
      .status(status.unwrap)
      .optionallyWith(
        title.map(value => FindingTitle.unwrap(value): java.lang.String)
      )(_.title)
      .`type`(`type`.unwrap)
      .optionallyWith(
        updatedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Finding.ReadOnly =
    zio.aws.inspector2.model.Finding.wrap(buildAwsValue())
}
object Finding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Finding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Finding =
      zio.aws.inspector2.model.Finding(
        awsAccountId,
        description,
        findingArn,
        firstObservedAt,
        inspectorScore.map(value => value),
        inspectorScoreDetails.map(value => value.asEditable),
        lastObservedAt,
        networkReachabilityDetails.map(value => value.asEditable),
        packageVulnerabilityDetails.map(value => value.asEditable),
        remediation.asEditable,
        resources.map { item =>
          item.asEditable
        },
        severity,
        status,
        title.map(value => value),
        `type`,
        updatedAt.map(value => value)
      )
    def awsAccountId: AccountId
    def description: FindingDescription
    def findingArn: FindingArn
    def firstObservedAt: DateTimeTimestamp
    def inspectorScore: Option[Double]
    def inspectorScoreDetails
        : Option[zio.aws.inspector2.model.InspectorScoreDetails.ReadOnly]
    def lastObservedAt: DateTimeTimestamp
    def networkReachabilityDetails
        : Option[zio.aws.inspector2.model.NetworkReachabilityDetails.ReadOnly]
    def packageVulnerabilityDetails
        : Option[zio.aws.inspector2.model.PackageVulnerabilityDetails.ReadOnly]
    def remediation: zio.aws.inspector2.model.Remediation.ReadOnly
    def resources: List[zio.aws.inspector2.model.Resource.ReadOnly]
    def severity: zio.aws.inspector2.model.Severity
    def status: zio.aws.inspector2.model.FindingStatus
    def title: Option[FindingTitle]
    def `type`: zio.aws.inspector2.model.FindingType
    def updatedAt: Option[DateTimeTimestamp]
    def getAwsAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(awsAccountId)
    def getDescription: ZIO[Any, Nothing, FindingDescription] =
      ZIO.succeed(description)
    def getFindingArn: ZIO[Any, Nothing, FindingArn] = ZIO.succeed(findingArn)
    def getFirstObservedAt: ZIO[Any, Nothing, DateTimeTimestamp] =
      ZIO.succeed(firstObservedAt)
    def getInspectorScore: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("inspectorScore", inspectorScore)
    def getInspectorScoreDetails: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.InspectorScoreDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("inspectorScoreDetails", inspectorScoreDetails)
    def getLastObservedAt: ZIO[Any, Nothing, DateTimeTimestamp] =
      ZIO.succeed(lastObservedAt)
    def getNetworkReachabilityDetails: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.NetworkReachabilityDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkReachabilityDetails",
      networkReachabilityDetails
    )
    def getPackageVulnerabilityDetails: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.PackageVulnerabilityDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "packageVulnerabilityDetails",
      packageVulnerabilityDetails
    )
    def getRemediation
        : ZIO[Any, Nothing, zio.aws.inspector2.model.Remediation.ReadOnly] =
      ZIO.succeed(remediation)
    def getResources
        : ZIO[Any, Nothing, List[zio.aws.inspector2.model.Resource.ReadOnly]] =
      ZIO.succeed(resources)
    def getSeverity: ZIO[Any, Nothing, zio.aws.inspector2.model.Severity] =
      ZIO.succeed(severity)
    def getStatus: ZIO[Any, Nothing, zio.aws.inspector2.model.FindingStatus] =
      ZIO.succeed(status)
    def getTitle: ZIO[Any, AwsError, FindingTitle] =
      AwsError.unwrapOptionField("title", title)
    def getType: ZIO[Any, Nothing, zio.aws.inspector2.model.FindingType] =
      ZIO.succeed(`type`)
    def getUpdatedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Finding
  ) extends zio.aws.inspector2.model.Finding.ReadOnly {
    override val awsAccountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.awsAccountId())
    override val description: FindingDescription =
      zio.aws.inspector2.model.primitives.FindingDescription(impl.description())
    override val findingArn: FindingArn =
      zio.aws.inspector2.model.primitives.FindingArn(impl.findingArn())
    override val firstObservedAt: DateTimeTimestamp =
      zio.aws.inspector2.model.primitives
        .DateTimeTimestamp(impl.firstObservedAt())
    override val inspectorScore: Option[Double] =
      scala.Option(impl.inspectorScore()).map(value => value: Double)
    override val inspectorScoreDetails
        : Option[zio.aws.inspector2.model.InspectorScoreDetails.ReadOnly] =
      scala
        .Option(impl.inspectorScoreDetails())
        .map(value =>
          zio.aws.inspector2.model.InspectorScoreDetails.wrap(value)
        )
    override val lastObservedAt: DateTimeTimestamp =
      zio.aws.inspector2.model.primitives
        .DateTimeTimestamp(impl.lastObservedAt())
    override val networkReachabilityDetails
        : Option[zio.aws.inspector2.model.NetworkReachabilityDetails.ReadOnly] =
      scala
        .Option(impl.networkReachabilityDetails())
        .map(value =>
          zio.aws.inspector2.model.NetworkReachabilityDetails.wrap(value)
        )
    override val packageVulnerabilityDetails: Option[
      zio.aws.inspector2.model.PackageVulnerabilityDetails.ReadOnly
    ] = scala
      .Option(impl.packageVulnerabilityDetails())
      .map(value =>
        zio.aws.inspector2.model.PackageVulnerabilityDetails.wrap(value)
      )
    override val remediation: zio.aws.inspector2.model.Remediation.ReadOnly =
      zio.aws.inspector2.model.Remediation.wrap(impl.remediation())
    override val resources: List[zio.aws.inspector2.model.Resource.ReadOnly] =
      impl
        .resources()
        .asScala
        .map { item =>
          zio.aws.inspector2.model.Resource.wrap(item)
        }
        .toList
    override val severity: zio.aws.inspector2.model.Severity =
      zio.aws.inspector2.model.Severity.wrap(impl.severity())
    override val status: zio.aws.inspector2.model.FindingStatus =
      zio.aws.inspector2.model.FindingStatus.wrap(impl.status())
    override val title: Option[FindingTitle] = scala
      .Option(impl.title())
      .map(value => zio.aws.inspector2.model.primitives.FindingTitle(value))
    override val `type`: zio.aws.inspector2.model.FindingType =
      zio.aws.inspector2.model.FindingType.wrap(impl.`type`())
    override val updatedAt: Option[DateTimeTimestamp] = scala
      .Option(impl.updatedAt())
      .map(value =>
        zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Finding
  ): zio.aws.inspector2.model.Finding.ReadOnly = new Wrapper(impl)
}
