package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.inspector2.model.primitives.{
  MapKey,
  FilterName,
  FilterDescription,
  OwnerId,
  FilterReason,
  MapValue,
  FilterArn,
  DateTimeTimestamp
}
import scala.jdk.CollectionConverters.*
final case class Filter(
    action: zio.aws.inspector2.model.FilterAction,
    arn: FilterArn,
    createdAt: DateTimeTimestamp,
    criteria: zio.aws.inspector2.model.FilterCriteria,
    description: Option[FilterDescription] = None,
    name: FilterName,
    ownerId: OwnerId,
    reason: Option[FilterReason] = None,
    tags: Option[Map[MapKey, MapValue]] = None,
    updatedAt: DateTimeTimestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Filter
      .builder()
      .action(action.unwrap)
      .arn(FilterArn.unwrap(arn): java.lang.String)
      .createdAt(DateTimeTimestamp.unwrap(createdAt): Instant)
      .criteria(criteria.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          FilterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(FilterName.unwrap(name): java.lang.String)
      .ownerId(OwnerId.unwrap(ownerId): java.lang.String)
      .optionallyWith(
        reason.map(value => FilterReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .updatedAt(DateTimeTimestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Filter.ReadOnly =
    zio.aws.inspector2.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Filter =
      zio.aws.inspector2.model.Filter(
        action,
        arn,
        createdAt,
        criteria.asEditable,
        description.map(value => value),
        name,
        ownerId,
        reason.map(value => value),
        tags.map(value => value),
        updatedAt
      )
    def action: zio.aws.inspector2.model.FilterAction
    def arn: FilterArn
    def createdAt: DateTimeTimestamp
    def criteria: zio.aws.inspector2.model.FilterCriteria.ReadOnly
    def description: Option[FilterDescription]
    def name: FilterName
    def ownerId: OwnerId
    def reason: Option[FilterReason]
    def tags: Option[Map[MapKey, MapValue]]
    def updatedAt: DateTimeTimestamp
    def getAction: ZIO[Any, Nothing, zio.aws.inspector2.model.FilterAction] =
      ZIO.succeed(action)
    def getArn: ZIO[Any, Nothing, FilterArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, DateTimeTimestamp] =
      ZIO.succeed(createdAt)
    def getCriteria
        : ZIO[Any, Nothing, zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      ZIO.succeed(criteria)
    def getDescription: ZIO[Any, AwsError, FilterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, FilterName] = ZIO.succeed(name)
    def getOwnerId: ZIO[Any, Nothing, OwnerId] = ZIO.succeed(ownerId)
    def getReason: ZIO[Any, AwsError, FilterReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, Nothing, DateTimeTimestamp] =
      ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Filter
  ) extends zio.aws.inspector2.model.Filter.ReadOnly {
    override val action: zio.aws.inspector2.model.FilterAction =
      zio.aws.inspector2.model.FilterAction.wrap(impl.action())
    override val arn: FilterArn =
      zio.aws.inspector2.model.primitives.FilterArn(impl.arn())
    override val createdAt: DateTimeTimestamp =
      zio.aws.inspector2.model.primitives.DateTimeTimestamp(impl.createdAt())
    override val criteria: zio.aws.inspector2.model.FilterCriteria.ReadOnly =
      zio.aws.inspector2.model.FilterCriteria.wrap(impl.criteria())
    override val description: Option[FilterDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.inspector2.model.primitives.FilterDescription(value)
      )
    override val name: FilterName =
      zio.aws.inspector2.model.primitives.FilterName(impl.name())
    override val ownerId: OwnerId =
      zio.aws.inspector2.model.primitives.OwnerId(impl.ownerId())
    override val reason: Option[FilterReason] = scala
      .Option(impl.reason())
      .map(value => zio.aws.inspector2.model.primitives.FilterReason(value))
    override val tags: Option[Map[MapKey, MapValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.inspector2.model.primitives.MapKey(
              key
            ) -> zio.aws.inspector2.model.primitives.MapValue(value)
          })
          .toMap
      )
    override val updatedAt: DateTimeTimestamp =
      zio.aws.inspector2.model.primitives.DateTimeTimestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Filter
  ): zio.aws.inspector2.model.Filter.ReadOnly = new Wrapper(impl)
}
