package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class EnableDelegatedAdminAccountResponse(
    delegatedAdminAccountId: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountResponse = {
    import EnableDelegatedAdminAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountResponse
      .builder()
      .delegatedAdminAccountId(
        AccountId.unwrap(delegatedAdminAccountId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse.ReadOnly =
    zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse
      .wrap(buildAwsValue())
}
object EnableDelegatedAdminAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse =
      zio.aws.inspector2.model
        .EnableDelegatedAdminAccountResponse(delegatedAdminAccountId)
    def delegatedAdminAccountId: AccountId
    def getDelegatedAdminAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(delegatedAdminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountResponse
  ) extends zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse.ReadOnly {
    override val delegatedAdminAccountId: AccountId =
      zio.aws.inspector2.model.primitives
        .AccountId(impl.delegatedAdminAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountResponse
  ): zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse.ReadOnly =
    new Wrapper(impl)
}
