package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{AccountId, ClientToken}
import scala.jdk.CollectionConverters.*
final case class EnableDelegatedAdminAccountRequest(
    clientToken: Option[ClientToken] = None,
    delegatedAdminAccountId: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest = {
    import EnableDelegatedAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .delegatedAdminAccountId(
        AccountId.unwrap(delegatedAdminAccountId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.EnableDelegatedAdminAccountRequest.ReadOnly =
    zio.aws.inspector2.model.EnableDelegatedAdminAccountRequest
      .wrap(buildAwsValue())
}
object EnableDelegatedAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.EnableDelegatedAdminAccountRequest =
      zio.aws.inspector2.model.EnableDelegatedAdminAccountRequest(
        clientToken.map(value => value),
        delegatedAdminAccountId
      )
    def clientToken: Option[ClientToken]
    def delegatedAdminAccountId: AccountId
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDelegatedAdminAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(delegatedAdminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest
  ) extends zio.aws.inspector2.model.EnableDelegatedAdminAccountRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.inspector2.model.primitives.ClientToken(value))
    override val delegatedAdminAccountId: AccountId =
      zio.aws.inspector2.model.primitives
        .AccountId(impl.delegatedAdminAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest
  ): zio.aws.inspector2.model.EnableDelegatedAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
