package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EcrRepositoryMetadata(
    name: Option[String] = None,
    scanFrequency: Option[zio.aws.inspector2.model.EcrScanFrequency] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EcrRepositoryMetadata = {
    import EcrRepositoryMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EcrRepositoryMetadata
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(scanFrequency.map(value => value.unwrap))(_.scanFrequency)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.EcrRepositoryMetadata.ReadOnly =
    zio.aws.inspector2.model.EcrRepositoryMetadata.wrap(buildAwsValue())
}
object EcrRepositoryMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EcrRepositoryMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.EcrRepositoryMetadata =
      zio.aws.inspector2.model.EcrRepositoryMetadata(
        name.map(value => value),
        scanFrequency.map(value => value)
      )
    def name: Option[String]
    def scanFrequency: Option[zio.aws.inspector2.model.EcrScanFrequency]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getScanFrequency
        : ZIO[Any, AwsError, zio.aws.inspector2.model.EcrScanFrequency] =
      AwsError.unwrapOptionField("scanFrequency", scanFrequency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EcrRepositoryMetadata
  ) extends zio.aws.inspector2.model.EcrRepositoryMetadata.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val scanFrequency
        : Option[zio.aws.inspector2.model.EcrScanFrequency] = scala
      .Option(impl.scanFrequency())
      .map(value => zio.aws.inspector2.model.EcrScanFrequency.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EcrRepositoryMetadata
  ): zio.aws.inspector2.model.EcrRepositoryMetadata.ReadOnly = new Wrapper(impl)
}
