package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EcrContainerImageMetadata(
    tags: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata = {
    import EcrContainerImageMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly =
    zio.aws.inspector2.model.EcrContainerImageMetadata.wrap(buildAwsValue())
}
object EcrContainerImageMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.EcrContainerImageMetadata =
      zio.aws.inspector2.model
        .EcrContainerImageMetadata(tags.map(value => value))
    def tags: Option[List[String]]
    def getTags: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata
  ) extends zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly {
    override val tags: Option[List[String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata
  ): zio.aws.inspector2.model.EcrContainerImageMetadata.ReadOnly = new Wrapper(
    impl
  )
}
