package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.{MapValue, MapKey, AmiId}
import scala.jdk.CollectionConverters.*
final case class Ec2Metadata(
    amiId: Option[AmiId] = None,
    platform: Option[zio.aws.inspector2.model.Ec2Platform] = None,
    tags: Option[Map[MapKey, MapValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Ec2Metadata = {
    import Ec2Metadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Ec2Metadata
      .builder()
      .optionallyWith(
        amiId.map(value => AmiId.unwrap(value): java.lang.String)
      )(_.amiId)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Ec2Metadata.ReadOnly =
    zio.aws.inspector2.model.Ec2Metadata.wrap(buildAwsValue())
}
object Ec2Metadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Ec2Metadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Ec2Metadata =
      zio.aws.inspector2.model.Ec2Metadata(
        amiId.map(value => value),
        platform.map(value => value),
        tags.map(value => value)
      )
    def amiId: Option[AmiId]
    def platform: Option[zio.aws.inspector2.model.Ec2Platform]
    def tags: Option[Map[MapKey, MapValue]]
    def getAmiId: ZIO[Any, AwsError, AmiId] =
      AwsError.unwrapOptionField("amiId", amiId)
    def getPlatform: ZIO[Any, AwsError, zio.aws.inspector2.model.Ec2Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2Metadata
  ) extends zio.aws.inspector2.model.Ec2Metadata.ReadOnly {
    override val amiId: Option[AmiId] = scala
      .Option(impl.amiId())
      .map(value => zio.aws.inspector2.model.primitives.AmiId(value))
    override val platform: Option[zio.aws.inspector2.model.Ec2Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.inspector2.model.Ec2Platform.wrap(value))
    override val tags: Option[Map[MapKey, MapValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.inspector2.model.primitives.MapKey(
              key
            ) -> zio.aws.inspector2.model.primitives.MapValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2Metadata
  ): zio.aws.inspector2.model.Ec2Metadata.ReadOnly = new Wrapper(impl)
}
