package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class DisableRequest(
    accountIds: Option[Iterable[AccountId]] = None,
    resourceTypes: Option[Iterable[zio.aws.inspector2.model.ResourceScanType]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DisableRequest = {
    import DisableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DisableRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resourceTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DisableRequest.ReadOnly =
    zio.aws.inspector2.model.DisableRequest.wrap(buildAwsValue())
}
object DisableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DisableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DisableRequest =
      zio.aws.inspector2.model.DisableRequest(
        accountIds.map(value => value),
        resourceTypes.map(value => value)
      )
    def accountIds: Option[List[AccountId]]
    def resourceTypes: Option[List[zio.aws.inspector2.model.ResourceScanType]]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getResourceTypes
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.ResourceScanType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DisableRequest
  ) extends zio.aws.inspector2.model.DisableRequest.ReadOnly {
    override val accountIds: Option[List[AccountId]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.AccountId(item)
        }.toList
      )
    override val resourceTypes
        : Option[List[zio.aws.inspector2.model.ResourceScanType]] = scala
      .Option(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.ResourceScanType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DisableRequest
  ): zio.aws.inspector2.model.DisableRequest.ReadOnly = new Wrapper(impl)
}
