package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConfigurationResponse(
    autoEnable: Option[zio.aws.inspector2.model.AutoEnable] = None,
    maxAccountLimitReached: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse = {
    import DescribeOrganizationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse
      .builder()
      .optionallyWith(autoEnable.map(value => value.buildAwsValue()))(
        _.autoEnable
      )
      .optionallyWith(
        maxAccountLimitReached.map(value => value: java.lang.Boolean)
      )(_.maxAccountLimitReached)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse =
      zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse(
        autoEnable.map(value => value.asEditable),
        maxAccountLimitReached.map(value => value)
      )
    def autoEnable: Option[zio.aws.inspector2.model.AutoEnable.ReadOnly]
    def maxAccountLimitReached: Option[Boolean]
    def getAutoEnable
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AutoEnable.ReadOnly] =
      AwsError.unwrapOptionField("autoEnable", autoEnable)
    def getMaxAccountLimitReached: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("maxAccountLimitReached", maxAccountLimitReached)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse
  ) extends zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly {
    override val autoEnable
        : Option[zio.aws.inspector2.model.AutoEnable.ReadOnly] = scala
      .Option(impl.autoEnable())
      .map(value => zio.aws.inspector2.model.AutoEnable.wrap(value))
    override val maxAccountLimitReached: Option[Boolean] =
      scala.Option(impl.maxAccountLimitReached()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse
  ): zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
