package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class CoverageMapFilter(
    comparison: zio.aws.inspector2.model.CoverageMapComparison,
    key: NonEmptyString,
    value: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CoverageMapFilter = {
    import CoverageMapFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CoverageMapFilter
      .builder()
      .comparison(comparison.unwrap)
      .key(NonEmptyString.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CoverageMapFilter.ReadOnly =
    zio.aws.inspector2.model.CoverageMapFilter.wrap(buildAwsValue())
}
object CoverageMapFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CoverageMapFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CoverageMapFilter =
      zio.aws.inspector2.model
        .CoverageMapFilter(comparison, key, value.map(value => value))
    def comparison: zio.aws.inspector2.model.CoverageMapComparison
    def key: NonEmptyString
    def value: Option[NonEmptyString]
    def getComparison
        : ZIO[Any, Nothing, zio.aws.inspector2.model.CoverageMapComparison] =
      ZIO.succeed(comparison)
    def getKey: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CoverageMapFilter
  ) extends zio.aws.inspector2.model.CoverageMapFilter.ReadOnly {
    override val comparison: zio.aws.inspector2.model.CoverageMapComparison =
      zio.aws.inspector2.model.CoverageMapComparison.wrap(impl.comparison())
    override val key: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.key())
    override val value: Option[NonEmptyString] = scala
      .Option(impl.value())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CoverageMapFilter
  ): zio.aws.inspector2.model.CoverageMapFilter.ReadOnly = new Wrapper(impl)
}
