package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchGetAccountStatusResponse(
    accounts: Iterable[zio.aws.inspector2.model.AccountState],
    failedAccounts: Option[Iterable[zio.aws.inspector2.model.FailedAccount]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusResponse = {
    import BatchGetAccountStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusResponse
      .builder()
      .accounts(accounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        failedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedAccounts)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.BatchGetAccountStatusResponse.ReadOnly =
    zio.aws.inspector2.model.BatchGetAccountStatusResponse.wrap(buildAwsValue())
}
object BatchGetAccountStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.BatchGetAccountStatusResponse =
      zio.aws.inspector2.model.BatchGetAccountStatusResponse(
        accounts.map { item =>
          item.asEditable
        },
        failedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accounts: List[zio.aws.inspector2.model.AccountState.ReadOnly]
    def failedAccounts
        : Option[List[zio.aws.inspector2.model.FailedAccount.ReadOnly]]
    def getAccounts: ZIO[Any, Nothing, List[
      zio.aws.inspector2.model.AccountState.ReadOnly
    ]] = ZIO.succeed(accounts)
    def getFailedAccounts: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.FailedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("failedAccounts", failedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusResponse
  ) extends zio.aws.inspector2.model.BatchGetAccountStatusResponse.ReadOnly {
    override val accounts
        : List[zio.aws.inspector2.model.AccountState.ReadOnly] = impl
      .accounts()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.AccountState.wrap(item)
      }
      .toList
    override val failedAccounts
        : Option[List[zio.aws.inspector2.model.FailedAccount.ReadOnly]] = scala
      .Option(impl.failedAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.FailedAccount.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusResponse
  ): zio.aws.inspector2.model.BatchGetAccountStatusResponse.ReadOnly =
    new Wrapper(impl)
}
