package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.inspector2.model.primitives.{
  IpV6Address,
  Platform,
  DateTimeTimestamp,
  IpV4Address,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class AwsEc2InstanceDetails(
    iamInstanceProfileArn: Option[NonEmptyString] = None,
    imageId: Option[NonEmptyString] = None,
    ipV4Addresses: Option[Iterable[IpV4Address]] = None,
    ipV6Addresses: Option[Iterable[IpV6Address]] = None,
    keyName: Option[NonEmptyString] = None,
    launchedAt: Option[DateTimeTimestamp] = None,
    platform: Option[Platform] = None,
    subnetId: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None,
    vpcId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails = {
    import AwsEc2InstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails
      .builder()
      .optionallyWith(
        iamInstanceProfileArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.iamInstanceProfileArn)
      .optionallyWith(
        imageId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        ipV4Addresses.map(value =>
          value.map { item =>
            IpV4Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipV4Addresses)
      .optionallyWith(
        ipV6Addresses.map(value =>
          value.map { item =>
            IpV6Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipV6Addresses)
      .optionallyWith(
        keyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(
        launchedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.launchedAt)
      .optionallyWith(
        platform.map(value => Platform.unwrap(value): java.lang.String)
      )(_.platform)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly =
    zio.aws.inspector2.model.AwsEc2InstanceDetails.wrap(buildAwsValue())
}
object AwsEc2InstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AwsEc2InstanceDetails =
      zio.aws.inspector2.model.AwsEc2InstanceDetails(
        iamInstanceProfileArn.map(value => value),
        imageId.map(value => value),
        ipV4Addresses.map(value => value),
        ipV6Addresses.map(value => value),
        keyName.map(value => value),
        launchedAt.map(value => value),
        platform.map(value => value),
        subnetId.map(value => value),
        `type`.map(value => value),
        vpcId.map(value => value)
      )
    def iamInstanceProfileArn: Option[NonEmptyString]
    def imageId: Option[NonEmptyString]
    def ipV4Addresses: Option[List[IpV4Address]]
    def ipV6Addresses: Option[List[IpV6Address]]
    def keyName: Option[NonEmptyString]
    def launchedAt: Option[DateTimeTimestamp]
    def platform: Option[Platform]
    def subnetId: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def vpcId: Option[NonEmptyString]
    def getIamInstanceProfileArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("iamInstanceProfileArn", iamInstanceProfileArn)
    def getImageId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getIpV4Addresses: ZIO[Any, AwsError, List[IpV4Address]] =
      AwsError.unwrapOptionField("ipV4Addresses", ipV4Addresses)
    def getIpV6Addresses: ZIO[Any, AwsError, List[IpV6Address]] =
      AwsError.unwrapOptionField("ipV6Addresses", ipV6Addresses)
    def getKeyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getLaunchedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("launchedAt", launchedAt)
    def getPlatform: ZIO[Any, AwsError, Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails
  ) extends zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly {
    override val iamInstanceProfileArn: Option[NonEmptyString] = scala
      .Option(impl.iamInstanceProfileArn())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val imageId: Option[NonEmptyString] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val ipV4Addresses: Option[List[IpV4Address]] = scala
      .Option(impl.ipV4Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.IpV4Address(item)
        }.toList
      )
    override val ipV6Addresses: Option[List[IpV6Address]] = scala
      .Option(impl.ipV6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.IpV6Address(item)
        }.toList
      )
    override val keyName: Option[NonEmptyString] = scala
      .Option(impl.keyName())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val launchedAt: Option[DateTimeTimestamp] = scala
      .Option(impl.launchedAt())
      .map(value =>
        zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
      )
    override val platform: Option[Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.inspector2.model.primitives.Platform(value))
    override val subnetId: Option[NonEmptyString] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEc2InstanceDetails
  ): zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly = new Wrapper(impl)
}
