package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class AssociateMemberResponse(accountId: AccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AssociateMemberResponse = {
    import AssociateMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AssociateMemberResponse
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AssociateMemberResponse.ReadOnly =
    zio.aws.inspector2.model.AssociateMemberResponse.wrap(buildAwsValue())
}
object AssociateMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AssociateMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AssociateMemberResponse =
      zio.aws.inspector2.model.AssociateMemberResponse(accountId)
    def accountId: AccountId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AssociateMemberResponse
  ) extends zio.aws.inspector2.model.AssociateMemberResponse.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AssociateMemberResponse
  ): zio.aws.inspector2.model.AssociateMemberResponse.ReadOnly = new Wrapper(
    impl
  )
}
