package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class AccountAggregationResponse(
    accountId: Option[AccountId] = None,
    severityCounts: Option[zio.aws.inspector2.model.SeverityCounts] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AccountAggregationResponse = {
    import AccountAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AccountAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AccountAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.AccountAggregationResponse.wrap(buildAwsValue())
}
object AccountAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AccountAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AccountAggregationResponse =
      zio.aws.inspector2.model.AccountAggregationResponse(
        accountId.map(value => value),
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Option[AccountId]
    def severityCounts: Option[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AccountAggregationResponse
  ) extends zio.aws.inspector2.model.AccountAggregationResponse.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val severityCounts
        : Option[zio.aws.inspector2.model.SeverityCounts.ReadOnly] = scala
      .Option(impl.severityCounts())
      .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AccountAggregationResponse
  ): zio.aws.inspector2.model.AccountAggregationResponse.ReadOnly = new Wrapper(
    impl
  )
}
