package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AccountAggregation(
    findingType: Option[zio.aws.inspector2.model.AggregationFindingType] = None,
    resourceType: Option[zio.aws.inspector2.model.AggregationResourceType] =
      None,
    sortBy: Option[zio.aws.inspector2.model.AccountSortBy] = None,
    sortOrder: Option[zio.aws.inspector2.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AccountAggregation = {
    import AccountAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AccountAggregation
      .builder()
      .optionallyWith(findingType.map(value => value.unwrap))(_.findingType)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AccountAggregation.ReadOnly =
    zio.aws.inspector2.model.AccountAggregation.wrap(buildAwsValue())
}
object AccountAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AccountAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AccountAggregation =
      zio.aws.inspector2.model.AccountAggregation(
        findingType.map(value => value),
        resourceType.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def findingType: Option[zio.aws.inspector2.model.AggregationFindingType]
    def resourceType: Option[zio.aws.inspector2.model.AggregationResourceType]
    def sortBy: Option[zio.aws.inspector2.model.AccountSortBy]
    def sortOrder: Option[zio.aws.inspector2.model.SortOrder]
    def getFindingType
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AggregationFindingType] =
      AwsError.unwrapOptionField("findingType", findingType)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AggregationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSortBy: ZIO[Any, AwsError, zio.aws.inspector2.model.AccountSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AccountAggregation
  ) extends zio.aws.inspector2.model.AccountAggregation.ReadOnly {
    override val findingType
        : Option[zio.aws.inspector2.model.AggregationFindingType] = scala
      .Option(impl.findingType())
      .map(value => zio.aws.inspector2.model.AggregationFindingType.wrap(value))
    override val resourceType
        : Option[zio.aws.inspector2.model.AggregationResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.inspector2.model.AggregationResourceType.wrap(value)
      )
    override val sortBy: Option[zio.aws.inspector2.model.AccountSortBy] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.inspector2.model.AccountSortBy.wrap(value))
    override val sortOrder: Option[zio.aws.inspector2.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AccountAggregation
  ): zio.aws.inspector2.model.AccountAggregation.ReadOnly = new Wrapper(impl)
}
