package zio.aws.inspector2
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.inspector2.model.primitives.{
  SubnetId,
  Tool,
  MapKey,
  LambdaLayerArn,
  SecurityGroupId,
  IpV6Address,
  UsageAccountId,
  AccountId,
  Cwe,
  VulnerabilityReferenceUrl,
  VulnId,
  FindingArn,
  MapValue,
  RelatedVulnerability,
  VulnerabilityId,
  Path,
  MeteringAccountId,
  FilterArn,
  IpV4Address,
  Target,
  NonEmptyString,
  TagKey,
  Ttp
}
import zio.aws.inspector2.model.primitives.Timestamp.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.inspector2.model.primitives.AccountId.Type
    object AggCounts extends Subtype[Long]
    type AggCounts = zio.aws.inspector2.model.primitives.AggCounts.Type
    object AmiId extends Subtype[String]
    type AmiId = zio.aws.inspector2.model.primitives.AmiId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.inspector2.model.primitives.Arn.Type
    object CisaAction extends Subtype[String]
    type CisaAction = zio.aws.inspector2.model.primitives.CisaAction.Type
    object CisaDateAdded extends Subtype[Instant]
    type CisaDateAdded = zio.aws.inspector2.model.primitives.CisaDateAdded.Type
    object CisaDateDue extends Subtype[Instant]
    type CisaDateDue = zio.aws.inspector2.model.primitives.CisaDateDue.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.inspector2.model.primitives.ClientToken.Type
    object CodeLineContentString extends Subtype[String]
    type CodeLineContentString =
      zio.aws.inspector2.model.primitives.CodeLineContentString.Type
    object Component extends Subtype[String]
    type Component = zio.aws.inspector2.model.primitives.Component.Type
    object ComponentType extends Subtype[String]
    type ComponentType = zio.aws.inspector2.model.primitives.ComponentType.Type
    object CoverageStringInput extends Subtype[String]
    type CoverageStringInput =
      zio.aws.inspector2.model.primitives.CoverageStringInput.Type
    object Cvss2BaseScore extends Subtype[Double]
    type Cvss2BaseScore =
      zio.aws.inspector2.model.primitives.Cvss2BaseScore.Type
    object Cvss2ScoringVector extends Subtype[String]
    type Cvss2ScoringVector =
      zio.aws.inspector2.model.primitives.Cvss2ScoringVector.Type
    object Cvss3BaseScore extends Subtype[Double]
    type Cvss3BaseScore =
      zio.aws.inspector2.model.primitives.Cvss3BaseScore.Type
    object Cvss3ScoringVector extends Subtype[String]
    type Cvss3ScoringVector =
      zio.aws.inspector2.model.primitives.Cvss3ScoringVector.Type
    object Cwe extends Subtype[String]
    type Cwe = zio.aws.inspector2.model.primitives.Cwe.Type
    object DateTimeTimestamp extends Subtype[Instant]
    type DateTimeTimestamp =
      zio.aws.inspector2.model.primitives.DateTimeTimestamp.Type
    object EpssScore extends Subtype[Double]
    type EpssScore = zio.aws.inspector2.model.primitives.EpssScore.Type
    object EpssScoreValue extends Subtype[Double]
    type EpssScoreValue =
      zio.aws.inspector2.model.primitives.EpssScoreValue.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.inspector2.model.primitives.ErrorMessage.Type
    object EvidenceDetail extends Subtype[String]
    type EvidenceDetail =
      zio.aws.inspector2.model.primitives.EvidenceDetail.Type
    object EvidenceRule extends Subtype[String]
    type EvidenceRule = zio.aws.inspector2.model.primitives.EvidenceRule.Type
    object EvidenceSeverity extends Subtype[String]
    type EvidenceSeverity =
      zio.aws.inspector2.model.primitives.EvidenceSeverity.Type
    object ExecutionRoleArn extends Subtype[String]
    type ExecutionRoleArn =
      zio.aws.inspector2.model.primitives.ExecutionRoleArn.Type
    object FilePath extends Subtype[String]
    type FilePath = zio.aws.inspector2.model.primitives.FilePath.Type
    object FilterArn extends Subtype[String]
    type FilterArn = zio.aws.inspector2.model.primitives.FilterArn.Type
    object FilterDescription extends Subtype[String]
    type FilterDescription =
      zio.aws.inspector2.model.primitives.FilterDescription.Type
    object FilterName extends Subtype[String]
    type FilterName = zio.aws.inspector2.model.primitives.FilterName.Type
    object FilterReason extends Subtype[String]
    type FilterReason = zio.aws.inspector2.model.primitives.FilterReason.Type
    object FindingArn extends Subtype[String]
    type FindingArn = zio.aws.inspector2.model.primitives.FindingArn.Type
    object FindingDescription extends Subtype[String]
    type FindingDescription =
      zio.aws.inspector2.model.primitives.FindingDescription.Type
    object FindingTitle extends Subtype[String]
    type FindingTitle = zio.aws.inspector2.model.primitives.FindingTitle.Type
    object FirstSeen extends Subtype[Instant]
    type FirstSeen = zio.aws.inspector2.model.primitives.FirstSeen.Type
    object FunctionName extends Subtype[String]
    type FunctionName = zio.aws.inspector2.model.primitives.FunctionName.Type
    object ImageHash extends Subtype[String]
    type ImageHash = zio.aws.inspector2.model.primitives.ImageHash.Type
    type Integer = Int
    object IpV4Address extends Subtype[String]
    type IpV4Address = zio.aws.inspector2.model.primitives.IpV4Address.Type
    object IpV6Address extends Subtype[String]
    type IpV6Address = zio.aws.inspector2.model.primitives.IpV6Address.Type
    object KmsKeyArn extends Subtype[String]
    type KmsKeyArn = zio.aws.inspector2.model.primitives.KmsKeyArn.Type
    object LambdaLayerArn extends Subtype[String]
    type LambdaLayerArn =
      zio.aws.inspector2.model.primitives.LambdaLayerArn.Type
    object LastSeen extends Subtype[Instant]
    type LastSeen = zio.aws.inspector2.model.primitives.LastSeen.Type
    object ListAccountPermissionsMaxResults extends Subtype[Int]
    type ListAccountPermissionsMaxResults =
      zio.aws.inspector2.model.primitives.ListAccountPermissionsMaxResults.Type
    object ListCoverageMaxResults extends Subtype[Int]
    type ListCoverageMaxResults =
      zio.aws.inspector2.model.primitives.ListCoverageMaxResults.Type
    object ListDelegatedAdminMaxResults extends Subtype[Int]
    type ListDelegatedAdminMaxResults =
      zio.aws.inspector2.model.primitives.ListDelegatedAdminMaxResults.Type
    object ListFilterMaxResults extends Subtype[Int]
    type ListFilterMaxResults =
      zio.aws.inspector2.model.primitives.ListFilterMaxResults.Type
    object ListFindingAggregationsMaxResults extends Subtype[Int]
    type ListFindingAggregationsMaxResults =
      zio.aws.inspector2.model.primitives.ListFindingAggregationsMaxResults.Type
    object ListFindingsMaxResults extends Subtype[Int]
    type ListFindingsMaxResults =
      zio.aws.inspector2.model.primitives.ListFindingsMaxResults.Type
    object ListMembersMaxResults extends Subtype[Int]
    type ListMembersMaxResults =
      zio.aws.inspector2.model.primitives.ListMembersMaxResults.Type
    object ListUsageTotalsMaxResults extends Subtype[Int]
    type ListUsageTotalsMaxResults =
      zio.aws.inspector2.model.primitives.ListUsageTotalsMaxResults.Type
    object ListUsageTotalsNextToken extends Subtype[String]
    type ListUsageTotalsNextToken =
      zio.aws.inspector2.model.primitives.ListUsageTotalsNextToken.Type
    object MapKey extends Subtype[String]
    type MapKey = zio.aws.inspector2.model.primitives.MapKey.Type
    object MapValue extends Subtype[String]
    type MapValue = zio.aws.inspector2.model.primitives.MapValue.Type
    object MeteringAccountId extends Subtype[String]
    type MeteringAccountId =
      zio.aws.inspector2.model.primitives.MeteringAccountId.Type
    object MonthlyCostEstimate extends Subtype[Double]
    type MonthlyCostEstimate =
      zio.aws.inspector2.model.primitives.MonthlyCostEstimate.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.inspector2.model.primitives.NextToken.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString.Type
    object OwnerId extends Subtype[String]
    type OwnerId = zio.aws.inspector2.model.primitives.OwnerId.Type
    object PackageArchitecture extends Subtype[String]
    type PackageArchitecture =
      zio.aws.inspector2.model.primitives.PackageArchitecture.Type
    object PackageEpoch extends Subtype[Int]
    type PackageEpoch = zio.aws.inspector2.model.primitives.PackageEpoch.Type
    object PackageName extends Subtype[String]
    type PackageName = zio.aws.inspector2.model.primitives.PackageName.Type
    object PackageRelease extends Subtype[String]
    type PackageRelease =
      zio.aws.inspector2.model.primitives.PackageRelease.Type
    object PackageVersion extends Subtype[String]
    type PackageVersion =
      zio.aws.inspector2.model.primitives.PackageVersion.Type
    object Path extends Subtype[String]
    type Path = zio.aws.inspector2.model.primitives.Path.Type
    object Platform extends Subtype[String]
    type Platform = zio.aws.inspector2.model.primitives.Platform.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.inspector2.model.primitives.Port.Type
    object RelatedVulnerability extends Subtype[String]
    type RelatedVulnerability =
      zio.aws.inspector2.model.primitives.RelatedVulnerability.Type
    object ReportId extends Subtype[String]
    type ReportId = zio.aws.inspector2.model.primitives.ReportId.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.inspector2.model.primitives.ResourceId.Type
    object ResourceStringInput extends Subtype[String]
    type ResourceStringInput =
      zio.aws.inspector2.model.primitives.ResourceStringInput.Type
    object RiskScore extends Subtype[Int]
    type RiskScore = zio.aws.inspector2.model.primitives.RiskScore.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.inspector2.model.primitives.SecurityGroupId.Type
    object SourceLayerHash extends Subtype[String]
    type SourceLayerHash =
      zio.aws.inspector2.model.primitives.SourceLayerHash.Type
    object StringInput extends Subtype[String]
    type StringInput = zio.aws.inspector2.model.primitives.StringInput.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.inspector2.model.primitives.SubnetId.Type
    object SuggestedFixCodeString extends Subtype[String]
    type SuggestedFixCodeString =
      zio.aws.inspector2.model.primitives.SuggestedFixCodeString.Type
    object SuggestedFixDescriptionString extends Subtype[String]
    type SuggestedFixDescriptionString =
      zio.aws.inspector2.model.primitives.SuggestedFixDescriptionString.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.inspector2.model.primitives.TagKey.Type
    object Target extends Subtype[String]
    type Target = zio.aws.inspector2.model.primitives.Target.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.inspector2.model.primitives.Timestamp.Type
    object Tool extends Subtype[String]
    type Tool = zio.aws.inspector2.model.primitives.Tool.Type
    object Ttp extends Subtype[String]
    type Ttp = zio.aws.inspector2.model.primitives.Ttp.Type
    object UsageAccountId extends Subtype[String]
    type UsageAccountId =
      zio.aws.inspector2.model.primitives.UsageAccountId.Type
    object UsageValue extends Subtype[Double]
    type UsageValue = zio.aws.inspector2.model.primitives.UsageValue.Type
    object VendorCreatedAt extends Subtype[Instant]
    type VendorCreatedAt =
      zio.aws.inspector2.model.primitives.VendorCreatedAt.Type
    object VendorSeverity extends Subtype[String]
    type VendorSeverity =
      zio.aws.inspector2.model.primitives.VendorSeverity.Type
    object VendorUpdatedAt extends Subtype[Instant]
    type VendorUpdatedAt =
      zio.aws.inspector2.model.primitives.VendorUpdatedAt.Type
    object Version extends Subtype[String]
    type Version = zio.aws.inspector2.model.primitives.Version.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.inspector2.model.primitives.VpcId.Type
    object VulnId extends Subtype[String]
    type VulnId = zio.aws.inspector2.model.primitives.VulnId.Type
    object VulnerabilityDescription extends Subtype[String]
    type VulnerabilityDescription =
      zio.aws.inspector2.model.primitives.VulnerabilityDescription.Type
    object VulnerabilityId extends Subtype[String]
    type VulnerabilityId =
      zio.aws.inspector2.model.primitives.VulnerabilityId.Type
    object VulnerabilityReferenceUrl extends Subtype[String]
    type VulnerabilityReferenceUrl =
      zio.aws.inspector2.model.primitives.VulnerabilityReferenceUrl.Type
    object VulnerabilitySourceUrl extends Subtype[String]
    type VulnerabilitySourceUrl =
      zio.aws.inspector2.model.primitives.VulnerabilitySourceUrl.Type
    object VulnerablePackageRemediation extends Subtype[String]
    type VulnerablePackageRemediation =
      zio.aws.inspector2.model.primitives.VulnerablePackageRemediation.Type
  }
  type AccountIdSet = List[AccountId]
  type AccountList = List[zio.aws.inspector2.model.Account]
  type AccountStateList = List[zio.aws.inspector2.model.AccountState]
  type AggregationResponseList =
    List[zio.aws.inspector2.model.AggregationResponse]
  type ArchitectureList = List[zio.aws.inspector2.model.Architecture]
  type BatchGetCodeSnippetRequestFindingArnsList = List[FindingArn]
  type BatchGetFreeTrialInfoRequestAccountIdsList = List[MeteringAccountId]
  type CodeLineList = List[zio.aws.inspector2.model.CodeLine]
  type CodeSnippetErrorList = List[zio.aws.inspector2.model.CodeSnippetError]
  type CodeSnippetResultList = List[zio.aws.inspector2.model.CodeSnippetResult]
  type CountsList = List[zio.aws.inspector2.model.Counts]
  type CoverageDateFilterList =
    List[zio.aws.inspector2.model.CoverageDateFilter]
  type CoverageMapFilterList = List[zio.aws.inspector2.model.CoverageMapFilter]
  type CoverageStringFilterList =
    List[zio.aws.inspector2.model.CoverageStringFilter]
  type CoveredResources = List[zio.aws.inspector2.model.CoveredResource]
  type CvssScoreAdjustmentList =
    List[zio.aws.inspector2.model.CvssScoreAdjustment]
  type CvssScoreList = List[zio.aws.inspector2.model.CvssScore]
  type CweList = List[NonEmptyString]
  type Cwes = List[Cwe]
  type DateFilterList = List[zio.aws.inspector2.model.DateFilter]
  type DelegatedAdminAccountList =
    List[zio.aws.inspector2.model.DelegatedAdminAccount]
  type DetectionPlatforms = List[NonEmptyString]
  type DetectorTagList = List[NonEmptyString]
  type DisableResourceTypeList = List[zio.aws.inspector2.model.ResourceScanType]
  type EnableResourceTypeList = List[zio.aws.inspector2.model.ResourceScanType]
  type EvidenceList = List[zio.aws.inspector2.model.Evidence]
  type FailedAccountList = List[zio.aws.inspector2.model.FailedAccount]
  type FailedMemberAccountEc2DeepInspectionStatusStateList = List[
    zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState
  ]
  type FilterArnList = List[FilterArn]
  type FilterList = List[zio.aws.inspector2.model.Filter]
  type FindingArnList = List[FindingArn]
  type FindingDetails = List[zio.aws.inspector2.model.FindingDetail]
  type FindingDetailsErrorList =
    List[zio.aws.inspector2.model.FindingDetailsError]
  type FindingList = List[zio.aws.inspector2.model.Finding]
  type FreeTrialAccountInfoList =
    List[zio.aws.inspector2.model.FreeTrialAccountInfo]
  type FreeTrialInfoErrorList =
    List[zio.aws.inspector2.model.FreeTrialInfoError]
  type FreeTrialInfoList = List[zio.aws.inspector2.model.FreeTrialInfo]
  type ImageTagList = List[NonEmptyString]
  type IpV4AddressList = List[IpV4Address]
  type IpV6AddressList = List[IpV6Address]
  type LambdaLayerList = List[String]
  type LayerList = List[LambdaLayerArn]
  type MapFilterList = List[zio.aws.inspector2.model.MapFilter]
  type MemberAccountEc2DeepInspectionStatusList =
    List[zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus]
  type MemberAccountEc2DeepInspectionStatusStateList =
    List[zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState]
  type MemberList = List[zio.aws.inspector2.model.Member]
  type NonEmptyStringList = List[NonEmptyString]
  type NumberFilterList = List[zio.aws.inspector2.model.NumberFilter]
  type PackageFilterList = List[zio.aws.inspector2.model.PackageFilter]
  type PathList = List[Path]
  type Permissions = List[zio.aws.inspector2.model.Permission]
  type PortRangeFilterList = List[zio.aws.inspector2.model.PortRangeFilter]
  type ReferenceUrls = List[NonEmptyString]
  type RelatedVulnerabilities = List[RelatedVulnerability]
  type ResourceList = List[zio.aws.inspector2.model.Resource]
  type ResourceMapFilterList = List[zio.aws.inspector2.model.ResourceMapFilter]
  type ResourceStringFilterList =
    List[zio.aws.inspector2.model.ResourceStringFilter]
  type SecurityGroupIdList = List[SecurityGroupId]
  type StepList = List[zio.aws.inspector2.model.Step]
  type StringFilterList = List[zio.aws.inspector2.model.StringFilter]
  type StringList = List[NonEmptyString]
  type SubnetIdList = List[SubnetId]
  type SuggestedFixes = List[zio.aws.inspector2.model.SuggestedFix]
  type TagKeyList = List[TagKey]
  type TagList = List[String]
  type TagMap = Map[MapKey, MapValue]
  type Targets = List[Target]
  type Tools = List[Tool]
  type Ttps = List[Ttp]
  type UsageAccountIdList = List[UsageAccountId]
  type UsageList = List[zio.aws.inspector2.model.Usage]
  type UsageTotalList = List[zio.aws.inspector2.model.UsageTotal]
  type VulnIdList = List[VulnId]
  type Vulnerabilities = List[zio.aws.inspector2.model.Vulnerability]
  type VulnerabilityIdList = List[VulnerabilityId]
  type VulnerabilityReferenceUrls = List[VulnerabilityReferenceUrl]
  type VulnerablePackageList = List[zio.aws.inspector2.model.VulnerablePackage]
}
