package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.VulnId
import scala.jdk.CollectionConverters._
final case class SearchVulnerabilitiesFilterCriteria(
    vulnerabilityIds: Iterable[VulnId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesFilterCriteria = {
    import SearchVulnerabilitiesFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesFilterCriteria
      .builder()
      .vulnerabilityIds(vulnerabilityIds.map { item =>
        VulnId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.SearchVulnerabilitiesFilterCriteria.ReadOnly =
    zio.aws.inspector2.model.SearchVulnerabilitiesFilterCriteria
      .wrap(buildAwsValue())
}
object SearchVulnerabilitiesFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.SearchVulnerabilitiesFilterCriteria =
      zio.aws.inspector2.model
        .SearchVulnerabilitiesFilterCriteria(vulnerabilityIds)
    def vulnerabilityIds: List[VulnId]
    def getVulnerabilityIds: ZIO[Any, Nothing, List[VulnId]] =
      ZIO.succeed(vulnerabilityIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesFilterCriteria
  ) extends zio.aws.inspector2.model.SearchVulnerabilitiesFilterCriteria.ReadOnly {
    override val vulnerabilityIds: List[VulnId] = impl
      .vulnerabilityIds()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.primitives.VulnId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesFilterCriteria
  ): zio.aws.inspector2.model.SearchVulnerabilitiesFilterCriteria.ReadOnly =
    new Wrapper(impl)
}
