package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters._
final case class FailedMemberAccountEc2DeepInspectionStatusState(
    accountId: AccountId,
    ec2ScanStatus: Optional[zio.aws.inspector2.model.Status] = Optional.Absent,
    errorMessage: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState = {
    import FailedMemberAccountEc2DeepInspectionStatusState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(ec2ScanStatus.map(value => value.unwrap))(_.ec2ScanStatus)
      .optionallyWith(
        errorMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState.ReadOnly =
    zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState
      .wrap(buildAwsValue())
}
object FailedMemberAccountEc2DeepInspectionStatusState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState =
      zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState(
        accountId,
        ec2ScanStatus.map(value => value),
        errorMessage.map(value => value)
      )
    def accountId: AccountId
    def ec2ScanStatus: Optional[zio.aws.inspector2.model.Status]
    def errorMessage: Optional[NonEmptyString]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getEc2ScanStatus: ZIO[Any, AwsError, zio.aws.inspector2.model.Status] =
      AwsError.unwrapOptionField("ec2ScanStatus", ec2ScanStatus)
    def getErrorMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState
  ) extends zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val ec2ScanStatus: Optional[zio.aws.inspector2.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2ScanStatus())
        .map(value => zio.aws.inspector2.model.Status.wrap(value))
    override val errorMessage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState
  ): zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState.ReadOnly =
    new Wrapper(impl)
}
