package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetFindingDetailsResponse(
    errors: Optional[Iterable[zio.aws.inspector2.model.FindingDetailsError]] =
      Optional.Absent,
    findingDetails: Optional[Iterable[zio.aws.inspector2.model.FindingDetail]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsResponse = {
    import BatchGetFindingDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        findingDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.BatchGetFindingDetailsResponse.ReadOnly =
    zio.aws.inspector2.model.BatchGetFindingDetailsResponse
      .wrap(buildAwsValue())
}
object BatchGetFindingDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.BatchGetFindingDetailsResponse =
      zio.aws.inspector2.model.BatchGetFindingDetailsResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors
        : Optional[List[zio.aws.inspector2.model.FindingDetailsError.ReadOnly]]
    def findingDetails
        : Optional[List[zio.aws.inspector2.model.FindingDetail.ReadOnly]]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.FindingDetailsError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getFindingDetails: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.FindingDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("findingDetails", findingDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsResponse
  ) extends zio.aws.inspector2.model.BatchGetFindingDetailsResponse.ReadOnly {
    override val errors: Optional[
      List[zio.aws.inspector2.model.FindingDetailsError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.FindingDetailsError.wrap(item)
        }.toList
      )
    override val findingDetails
        : Optional[List[zio.aws.inspector2.model.FindingDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.FindingDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsResponse
  ): zio.aws.inspector2.model.BatchGetFindingDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
