package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListFiltersResponse(
    filters: Iterable[zio.aws.inspector2.model.Filter],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListFiltersResponse = {
    import ListFiltersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListFiltersResponse
      .builder()
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListFiltersResponse.ReadOnly =
    zio.aws.inspector2.model.ListFiltersResponse.wrap(buildAwsValue())
}
object ListFiltersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListFiltersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListFiltersResponse =
      zio.aws.inspector2.model.ListFiltersResponse(
        filters.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def filters: List[zio.aws.inspector2.model.Filter.ReadOnly]
    def nextToken: Optional[NextToken]
    def getFilters
        : ZIO[Any, Nothing, List[zio.aws.inspector2.model.Filter.ReadOnly]] =
      ZIO.succeed(filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListFiltersResponse
  ) extends zio.aws.inspector2.model.ListFiltersResponse.ReadOnly {
    override val filters: List[zio.aws.inspector2.model.Filter.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.Filter.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListFiltersResponse
  ): zio.aws.inspector2.model.ListFiltersResponse.ReadOnly = new Wrapper(impl)
}
