package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  NextToken,
  ListDelegatedAdminMaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDelegatedAdminAccountsRequest(
    maxResults: Optional[ListDelegatedAdminMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest = {
    import ListDelegatedAdminAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListDelegatedAdminMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest.ReadOnly =
    zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest
      .wrap(buildAwsValue())
}
object ListDelegatedAdminAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest =
      zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListDelegatedAdminMaxResults]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, ListDelegatedAdminMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest
  ) extends zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest.ReadOnly {
    override val maxResults: Optional[ListDelegatedAdminMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives
            .ListDelegatedAdminMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest
  ): zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest.ReadOnly =
    new Wrapper(impl)
}
