package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait LambdaLayerSortBy {
  def unwrap: software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy
}
object LambdaLayerSortBy {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy
  ): zio.aws.inspector2.model.LambdaLayerSortBy = value match {
    case software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.LambdaLayerSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy =
      software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.inspector2.model.LambdaLayerSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy =
      software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy.CRITICAL
  }
  case object HIGH extends zio.aws.inspector2.model.LambdaLayerSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy =
      software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy.HIGH
  }
  case object ALL extends zio.aws.inspector2.model.LambdaLayerSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy =
      software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy.ALL
  }
}
