package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait FindingDetailsErrorCode {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode
}
object FindingDetailsErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode
  ): zio.aws.inspector2.model.FindingDetailsErrorCode = value match {
    case software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode.FINDING_DETAILS_NOT_FOUND =>
      val r = FINDING_DETAILS_NOT_FOUND
      r
    case software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode.INVALID_INPUT =>
      val r = INVALID_INPUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.FindingDetailsErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode =
      software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_ERROR
      extends zio.aws.inspector2.model.FindingDetailsErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode =
      software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode.INTERNAL_ERROR
  }
  case object ACCESS_DENIED
      extends zio.aws.inspector2.model.FindingDetailsErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode =
      software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode.ACCESS_DENIED
  }
  case object FINDING_DETAILS_NOT_FOUND
      extends zio.aws.inspector2.model.FindingDetailsErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode =
      software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode.FINDING_DETAILS_NOT_FOUND
  }
  case object INVALID_INPUT
      extends zio.aws.inspector2.model.FindingDetailsErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode =
      software.amazon.awssdk.services.inspector2.model.FindingDetailsErrorCode.INVALID_INPUT
  }
}
