package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.KmsKeyArn
import scala.jdk.CollectionConverters._
final case class GetEncryptionKeyResponse(kmsKeyId: KmsKeyArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyResponse = {
    import GetEncryptionKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyResponse
      .builder()
      .kmsKeyId(KmsKeyArn.unwrap(kmsKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.GetEncryptionKeyResponse.ReadOnly =
    zio.aws.inspector2.model.GetEncryptionKeyResponse.wrap(buildAwsValue())
}
object GetEncryptionKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetEncryptionKeyResponse =
      zio.aws.inspector2.model.GetEncryptionKeyResponse(kmsKeyId)
    def kmsKeyId: KmsKeyArn
    def getKmsKeyId: ZIO[Any, Nothing, KmsKeyArn] = ZIO.succeed(kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyResponse
  ) extends zio.aws.inspector2.model.GetEncryptionKeyResponse.ReadOnly {
    override val kmsKeyId: KmsKeyArn =
      zio.aws.inspector2.model.primitives.KmsKeyArn(impl.kmsKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyResponse
  ): zio.aws.inspector2.model.GetEncryptionKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
