package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetConfigurationResponse(
    ecrConfiguration: Optional[zio.aws.inspector2.model.EcrConfigurationState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetConfigurationResponse = {
    import GetConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetConfigurationResponse
      .builder()
      .optionallyWith(ecrConfiguration.map(value => value.buildAwsValue()))(
        _.ecrConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.GetConfigurationResponse.ReadOnly =
    zio.aws.inspector2.model.GetConfigurationResponse.wrap(buildAwsValue())
}
object GetConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetConfigurationResponse =
      zio.aws.inspector2.model.GetConfigurationResponse(
        ecrConfiguration.map(value => value.asEditable)
      )
    def ecrConfiguration
        : Optional[zio.aws.inspector2.model.EcrConfigurationState.ReadOnly]
    def getEcrConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.EcrConfigurationState.ReadOnly
    ] = AwsError.unwrapOptionField("ecrConfiguration", ecrConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetConfigurationResponse
  ) extends zio.aws.inspector2.model.GetConfigurationResponse.ReadOnly {
    override val ecrConfiguration
        : Optional[zio.aws.inspector2.model.EcrConfigurationState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecrConfiguration())
        .map(value =>
          zio.aws.inspector2.model.EcrConfigurationState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetConfigurationResponse
  ): zio.aws.inspector2.model.GetConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
