package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{LastSeen, FirstSeen}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ExploitObserved(
    firstSeen: Optional[FirstSeen] = Optional.Absent,
    lastSeen: Optional[LastSeen] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ExploitObserved = {
    import ExploitObserved.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ExploitObserved
      .builder()
      .optionallyWith(firstSeen.map(value => FirstSeen.unwrap(value): Instant))(
        _.firstSeen
      )
      .optionallyWith(lastSeen.map(value => LastSeen.unwrap(value): Instant))(
        _.lastSeen
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ExploitObserved.ReadOnly =
    zio.aws.inspector2.model.ExploitObserved.wrap(buildAwsValue())
}
object ExploitObserved {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ExploitObserved
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ExploitObserved =
      zio.aws.inspector2.model.ExploitObserved(
        firstSeen.map(value => value),
        lastSeen.map(value => value)
      )
    def firstSeen: Optional[FirstSeen]
    def lastSeen: Optional[LastSeen]
    def getFirstSeen: ZIO[Any, AwsError, FirstSeen] =
      AwsError.unwrapOptionField("firstSeen", firstSeen)
    def getLastSeen: ZIO[Any, AwsError, LastSeen] =
      AwsError.unwrapOptionField("lastSeen", lastSeen)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ExploitObserved
  ) extends zio.aws.inspector2.model.ExploitObserved.ReadOnly {
    override val firstSeen: Optional[FirstSeen] = zio.aws.core.internal
      .optionalFromNullable(impl.firstSeen())
      .map(value => zio.aws.inspector2.model.primitives.FirstSeen(value))
    override val lastSeen: Optional[LastSeen] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSeen())
      .map(value => zio.aws.inspector2.model.primitives.LastSeen(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ExploitObserved
  ): zio.aws.inspector2.model.ExploitObserved.ReadOnly = new Wrapper(impl)
}
