package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeOrganizationConfigurationResponse(
    autoEnable: Optional[zio.aws.inspector2.model.AutoEnable] = Optional.Absent,
    maxAccountLimitReached: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse = {
    import DescribeOrganizationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse
      .builder()
      .optionallyWith(autoEnable.map(value => value.buildAwsValue()))(
        _.autoEnable
      )
      .optionallyWith(
        maxAccountLimitReached.map(value => value: java.lang.Boolean)
      )(_.maxAccountLimitReached)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse =
      zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse(
        autoEnable.map(value => value.asEditable),
        maxAccountLimitReached.map(value => value)
      )
    def autoEnable: Optional[zio.aws.inspector2.model.AutoEnable.ReadOnly]
    def maxAccountLimitReached: Optional[Boolean]
    def getAutoEnable
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AutoEnable.ReadOnly] =
      AwsError.unwrapOptionField("autoEnable", autoEnable)
    def getMaxAccountLimitReached: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("maxAccountLimitReached", maxAccountLimitReached)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse
  ) extends zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly {
    override val autoEnable
        : Optional[zio.aws.inspector2.model.AutoEnable.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoEnable())
        .map(value => zio.aws.inspector2.model.AutoEnable.wrap(value))
    override val maxAccountLimitReached: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAccountLimitReached())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse
  ): zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
